/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.process;

import cn.com.duiba.kjy.api.enums.process.ProcessTypeEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public enum ProcessRoleTypeEnum {
    SALES_MANAGER(1, "\u9500\u552e\u4e3b\u7ba1"),
    FINANCE(2, "\u8d22\u52a1"),
    REFUND_FINANCE(3, "\u9000\u6b3e\u8d22\u52a1");

    private Integer code;
    private String desc;
    private static final Map<Integer, ProcessRoleTypeEnum> ENUM_MAP;
    private static final List<ProcessRoleTypeEnum> SERIAL_CHECK_PROCESS;
    private static final List<ProcessRoleTypeEnum> REFIUND_CHECK_PROCESS;

    private ProcessRoleTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public static ProcessRoleTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static ProcessRoleTypeEnum nextRoleType(ProcessRoleTypeEnum processRoleTypeEnum, Integer processTypeEnum) {
        List<ProcessRoleTypeEnum> processRoleTypeEnums = null;
        if (ProcessTypeEnum.SERIAL_CHECK.getCode().equals(processTypeEnum)) {
            processRoleTypeEnums = SERIAL_CHECK_PROCESS;
        } else if (ProcessTypeEnum.REFUND_CHECK.getCode().equals(processTypeEnum)) {
            processRoleTypeEnums = REFIUND_CHECK_PROCESS;
        }
        if (CollectionUtils.isEmpty(processRoleTypeEnums)) {
            return null;
        }
        int index = processRoleTypeEnums.indexOf((Object)processRoleTypeEnum);
        if (index + 1 >= processRoleTypeEnums.size()) {
            return null;
        }
        return processRoleTypeEnums.get(index + 1);
    }

    static {
        ENUM_MAP = new HashMap<Integer, ProcessRoleTypeEnum>();
        for (ProcessRoleTypeEnum tmp : ProcessRoleTypeEnum.values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
        SERIAL_CHECK_PROCESS = Arrays.asList(SALES_MANAGER, FINANCE);
        REFIUND_CHECK_PROCESS = Arrays.asList(SALES_MANAGER, REFUND_FINANCE);
    }
}

