package cn.com.duiba.kjy.api.enums.user;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2020-07-10 17:17
 * @descript 访问记录排序类型
 */
public enum UserVisitEsSortTypeSceneEnum {

    WHO_SAW_ME_LIST(1, "谁看过我列表"),
    MY_FORWARD_RECORD_LIST(2, "我的转发访客列表"),
    ;

    private Integer code;
    private String description;

    UserVisitEsSortTypeSceneEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据code查询
     * @param code
     * @return
     */
    public static UserVisitEsSortTypeSceneEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (UserVisitEsSortTypeSceneEnum sortTypeSceneEnum : UserVisitEsSortTypeSceneEnum.values()) {
            if (Objects.equals(sortTypeSceneEnum.getCode(), code)) {
                return sortTypeSceneEnum;
            }
        }
        return null;
    }

}
