package cn.com.duiba.kjy.api.mqmsg;

import lombok.Data;

import java.io.Serializable;

/**
 * 功能描述：推送
 *
 * @Auther: xiaotian
 * @Date: 2020/7/14 19:13
 * @Description:
 */
@Data
public class SendPushForScanMsg implements Serializable {

    private static final long serialVersionUID = 3094392963321996127L;


    /**
     * 访客Id
     */
    private Long visitId;

    /**
     * 销售Id
     */
    private Long sellerId;

    /**
     * 销售员文章id
     */
    private Long   scId;

    /**
     * 指定线索类型
     * @see cn.com.duiba.kjy.api.enums.clue.VisitClueTypeEnum
     */
    private String clueTypeName;

    /**
     * 问答id
     */
    private Long   qId;

    /**
     * 资料包Id
     */
    private Long materialId;

    /**
     *
     *最终来源Id ：  文章ID  问答ID
     */
    private Long sourceId;

    /**
     *
     *最终来源类型 ：1:文章  2:问答
     * @see cn.com.duiba.kjy.api.enums.explosioncontent.FaqClueSourceTypeEnum
     */
    private Integer sourceType;

    /**
     *
     *来源位置 0:无 1:文章内  2:个人专栏
     * @see cn.com.duiba.kjy.api.enums.explosioncontent.LocationSourceEnum
     */
    private Integer locationSource;

    /**
     * 赠险Id
     */
    private Long insuranceId;

}
