package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.UserDto;
import cn.com.duiba.kjy.api.dto.user.TestUserDto;
import cn.com.duiba.kjy.api.dto.user.TestUserInfoDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.user.TestUserQueryParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/5/26 14:14
 */
@AdvancedFeignClient
public interface RemoteTestUserService {

    /**
     * 根据用户id查询
     * @param userId 用户id
     * @return 测试账号信息
     */
    TestUserDto findByUserId(Long userId);

    /**
     * 根据用户id集合查询
     * @param userIds 用户id集合
     * @return 测试账号信息集合
     */
    List<TestUserDto> findByUserIds(List<Long> userIds);

    /**
     * 列表查询，分页
     * @param param 查询参数
     * @return 测试账户集合
     */
    Page<TestUserInfoDto> findListByParam(TestUserQueryParam param);

    /**
     * 统计数据
     * @param param 统计条件
     * @return 执行结果
     */
    Integer countByParam(TestUserQueryParam param);

    /**
     * 软删除账户
     * @param id 主键id
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 修改数据
     * @param dto 账户信息
     * @return 执行结果
     */
    boolean update(TestUserDto dto);

    /**
     * 保存
     * @param dto 账户信息
     * @return 执行结果
     */
    int save(TestUserDto dto);

    /**
     * 保存
     * @param userDto 用户信息
     * @return 执行结果
     */
    boolean saveByUser(UserDto userDto);

    /**
     * 根据主键id查询
     * @param id 主键id
     * @return 测试账户信息
     */
    TestUserDto findById(Long id);
}
