package cn.com.duiba.kjy.api.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/6/3.
 */
@Data
@ToString
public class UserExtDto implements Serializable {

    private static final long serialVersionUID = 6596196396308160191L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 公众号是否已关注：0=未关注、1=已关注
     */
    private Integer subscribe;

    /**
     * 类型：oa=公众号、mp=小程序
     */
    private String extType;

    /**
     * 微信接口返回 session_key，用户解密敏感数据
     */
    private String accessToken;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     *是否正在使用
     */
    private Boolean using;

    /**
     * 首次关注时间
     */
    private Date firstSubscribeTime;

    /**
     * 最近一次关注时间
     */
    private Date lastSubscribeTime;

    /**
     * 微信接口返回 refreshToken，有效期30天
     */
    private String refreshToken;
}
