package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ActivationCodeBatchDto;
import cn.com.duiba.kjy.api.dto.ActivationCodeDto;
import cn.com.duiba.kjy.api.params.Activationcode.ActivationCodeAddDto;
import cn.com.duiba.kjy.api.params.Activationcode.ActivationCodePageQryParams;

import java.util.List;

/**
 * Created by dugq on 2019-03-16.
 */
@AdvancedFeignClient
public interface RemoteActivationCodeService {
    /**
     * 根据激活码查询记录
     * @param code
     * @return
     */
    ActivationCodeDto selectOneByCode(String code);

    /**
     * 查询用户使用使用过的激活码
     * @param userId
     * @return
     */
    List<ActivationCodeDto> selectListByUserId(Long userId);


    /**
     * 查询批次中的激活码
     * @param batch
     * @param effective
     * @return
     */
    List<ActivationCodeDto> selectListByBath(String batch, Byte effective);

    /**
     * 使用激活码
     * @param sellerId
     * @param code
     * @return
     */
    int activate(Long sellerId, String code) throws BizException;

    Integer selectCount(ActivationCodeDto pojo);

    /**
     * 生成激活码
     * @param codeAddDto
     * @return
     */
    int batchInsert(ActivationCodeAddDto codeAddDto);

    /**
     * 获取当前用户激活的激活码 所在的公司ID
     * @param userId
     * @return
     */
    Long findCompanyByActivation(Long userId);

    List<ActivationCodeBatchDto> findBatchInfo();

    /**
     * 分页查询数据
     * @param param
     * @return
     */
    List<ActivationCodeDto> findPageList(ActivationCodePageQryParams param);

    /**
     * 获取总条数
     * @param param
     * @return
     */
    int findPageCount(ActivationCodePageQryParams param);
}
