package cn.com.duiba.kjy.api.enums.seller;

/**
 * @author wangbinbin
 * @create 2019-08-13 15:34
 * @descript 获客线索类型枚举
 */
public enum ClueTypeEnum {
    USER_VISIT("userVisit", "用户访问", 1),
    USER_FORWARD("userForward", "用户转发", 5),
    SUBMIT_MATERIAL("submitMaterial", "填写资料", 10),
    ACTIVITY_PRIZE("activityPrize", "活动中奖", 15),
    VOTE_MORNING("voteMorning", "早报投票", 10),
    VOTE_EVENING("voteEvening", "晚报投票", 10),
    VOTE_ARTICLE("voteArticle", "文章投票", 10),
    ANSWER_MORNING("answerMorning", "早报答题", 10),
    ANSWER_EVENING("answerEvening", "晚报答题", 10),
    ANSWER_ARTICLE("answerArticle", "文章答题", 10)
    ;

    private String code;
    private String descript;
    private int coefficient;

    ClueTypeEnum(String code, String descript, int coefficient) {
        this.code = code;
        this.descript = descript;
        this.coefficient = coefficient;
    }

    public String getCode() {
        return code;
    }

    public String getDescript() {
        return descript;
    }

    public int getCoefficient() {
        return coefficient;
    }

    /**
     * 根据代码类型获取系数
     * @param type
     * @return
     */
    public static int getCoefficientByCode(String type) {
        for (ClueTypeEnum clueTypeEnum : ClueTypeEnum.values()) {
            if (clueTypeEnum.getCode().equals(type)) {
                return clueTypeEnum.getCoefficient();
            }
        }
        return 0;
    }
}
