package cn.com.duiba.kjy.api.mp;

import cn.com.duiba.kjy.api.constant.UserRoleEnum;
import cn.com.duiba.kjy.api.enums.OATypeEnum;
import org.apache.commons.lang.StringUtils;

/**
 * @Auther: Tt(yehuawei)
 * @Date: 2019/7/8 0008 15:09
 */
public enum LoginSenceEnum {
    DEFAULT("Default",OATypeEnum.MP,UserRoleEnum.SELLER,"默认场景，兼容原有代码，原有代码默认为DEFAULT场景"),
    PRIVATE_CHAT_LOGIN("PrivateChat",OATypeEnum.MP,UserRoleEnum.USER,"通过私信推送的二维码进入小程序，授权后为客户"),
    SHARE_MINIPROGRAM_CONTENT_CARD("ShareMiniprogram",OATypeEnum.MP,UserRoleEnum.USER,"通过其他代理人分享的内容小程序卡片，授权后成为客户"),
    SEARCH_MINIPROGRAM("SearchMiniprogram",OATypeEnum.MP,UserRoleEnum.SELLER,"通过自然搜索小程序，授权后成为销售身份"),
    SCAN_MINIPROGRAM_QRCODE("ScanMiniprogramQrcode",OATypeEnum.MP,UserRoleEnum.SELLER,"通过扫描小程序码，授权成为销售身份")
    ;


    LoginSenceEnum(String sence, OATypeEnum oaType, UserRoleEnum role, String desc) {
        this.sence = sence;
        this.desc = desc;
        this.oaType = oaType;
        this.role = role;
    }

    /**
     * 场景值
     */
    private String sence;
    /**
     * 场景描述
     */
    private String desc;
    /**
     * 公众号/小程序类型
     */
    private OATypeEnum oaType;
    /**
     * 该场景对应的角色
     */
    private UserRoleEnum role;

    /**
     * 根据场景值（sence）获取枚举
     * @param sence
     * @return
     */
    public static LoginSenceEnum Of(String sence){
        if (StringUtils.isBlank(sence)){
            return DEFAULT;
        }
        for (LoginSenceEnum loginSenceEnum:values()){
            if (sence.equals(loginSenceEnum.getSence())){
                return loginSenceEnum;
            }
        }
        return null;
    }

    public String getSence() {
        return sence;
    }

    public void setSence(String sence) {
        this.sence = sence;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public OATypeEnum getOaType() {
        return oaType;
    }

    public void setOaType(OATypeEnum oaType) {
        this.oaType = oaType;
    }

    public UserRoleEnum getRole() {
        return role;
    }

    public void setRole(UserRoleEnum role) {
        this.role = role;
    }
}
