package cn.com.duiba.kjy.api.remoteservice.privatechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.privatechat.*;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.privatechat.ChatReadedParam;
import cn.com.duiba.kjy.api.params.privatechat.ChatSendParam;
import cn.com.duiba.kjy.api.params.privatechat.CheckUnreadParam;

import java.util.List;

/**
 * 私信接口
 * @Auther: Tt(yehuawei)
 * @Date: 2019/6/28 0028 14:23
 */
@AdvancedFeignClient
public interface RemotePrivateChatService {
    /**
     * 内容页-查询是否存在未读消息
     * @param checkUnreadParam
     * @return
     */
    CheckUnreadDto checkUnread(CheckUnreadParam checkUnreadParam);

    /**
     * 聊天页-发送消息
     * @param chatSendParam
     * @return
     */
    Boolean send(ChatSendParam chatSendParam);

    /**
     * 聊天页-首次获取聊天内容
     * @param currentRoleId
     * @param anotherId
     * @param pageSize
     * @return
     */
    ChatContentListDto list(Integer role,Long currentRoleId , Long anotherId, Integer pageSize);

    /**
     * 聊天页-下拉获取历史聊天记录
     * @param currentRoleId
     * @param anotherId
     * @param pageSize
     * @param topId
     * @return
     */
    ChatContentHistoryListDto history(Integer role,Long currentRoleId, Long anotherId, Integer pageSize, Long topId);

    /**
     * 聊天页-获取最新消息
     * @param currentRoleId
     * @param anotherId
     * @param lastId
     * @return
     */
    ChatContentNewListDto news(Integer role,Long currentRoleId, Long anotherId, Long lastId);

    /**
     * 聊天页-消息已读
     * @param chatReadedParam
     * @return
     */
    Boolean readed(ChatReadedParam chatReadedParam);

    /**
     * 聊天列表-客户获取联络人列表
     * @return
     */
    Page<UserLinkmanDto> userLinkmanList(Long userId,Integer pageIndex, Integer pageSize);

    /**
     * 聊天列表-代理人获取联络客户列表
     * @return
     */
    Page<SellerLinkmanDto> sellerLinkmanList(Long sellerId,Integer pageIndex, Integer pageSize);

    /**
     * 聊天列表-代理人未读消息总数
     * @return
     */
    Integer sellerUnreadCount(Long sellerId);

    /**
     * 分享列表-代理人分享历史列表
     * @param sellerId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    Page<SellerContentBaseInfoDto> sellerContentHistory(Long sellerId,Integer pageIndex,Integer pageSize);
}
