package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerMaterialDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerMaterialQryParam;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/6/29 17:18
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerMaterialService {

    /**
     * 根据代理人id和客户用户id查询数量
     * @param sellerId
     * @param userId
     * @return
     */
    Integer countNumBySellerIdAndUserId(Long sellerId, Long userId);


    /**
     * 查询列表
     * @param param
     * @return
     */
    List<SellerCustomerMaterialDto> listByParams(SellerCustomerMaterialQryParam param);


    /**
     * 分页查询提交资料
     * @param param
     * @return
     */
    Page<SellerCustomerMaterialDto> getMaterialPage(SellerCustomerMaterialQryParam param);

    /**
     * 根据材料id获取数据
     * @param materialId
     * @return
     */
    SellerCustomerMaterialDto listById(Long materialId);

    /**
     * 根据代理人内容id查询总数
     * @param scId
     * @return
     */
    Integer countNumByScId(Long scId);

    /**
     * 根据代理人内容Id查询提交资料
     * @param scId
     * @return key=userId value=Id
     */
    Map<Long, Long> getSubmitMaterialMenMapByScId(Long scId);


    /**
     * 新增或更新
     * @param dto
     * @return
     */
    Boolean saveOrUpdate(SellerCustomerMaterialDto dto);

    /**
     * 提交资料数
     * @return key = scId  value=提交资料的userIds
     */
    Map<Long, List<Long>> getSubmitMaterialNumMap(List<Long> scIds);

}
