package cn.com.duiba.kjy.api.util;


/**
 * Created by dugq on 2019-02-21.
 */
public enum ErrorCode implements ErrorCodeInterface {
    //通用
    DATE_ERROR("990001","数据错误"),

    //00 : 内容
    N000000("000000","内容模块"),
    INSERT_ERROR("000001","内容主表插入失败"),
    CONTENT_EXT_ERROR("000002","内容扩展表插入失败"),
    TARGET_SORT_ERROR("000003","目标位置不存在，目标位置超过了总数"),


    //01 销售模块
    N010001("010001","更新用户信息错误"),
    N010002("010002","支付记录状态错误"),

    //02 用户模块
    N020001("020001","保存用户信息错误"),
    N020002("020002","保存用户扩展信息错误"),
    N020003("020003","更新用户信息错误"),
    N020004("020004","保存用户扩展信息错误"),
    N020005("020005","更新用户扩展信息错误"),

    //03激活码
    ALREADY_USED("030001","激活码已经使用"),
    NOT_SELLER("030002","非销售不能激活"),
    UN_USEFUL("030003","无用的或者非法的激活码"),
    ADD_VIP_TIME("030004","添加vip时间错误"),
    ALREADY_ACTIVATED("030005","该用户已经使用过一次了"),
        ;

    private String shortCode;
    private String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "01";
    }

    @Override
    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
