package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.constant.UserRoleEnum;
import cn.com.duiba.wolf.utils.BlowfishUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 私信会话工具
 *
 * @Auther: Tt(yehuawei)
 * @Date: 2019/7/9 0009 10:02
 */
public class PrivateChatSessionUtil {

    /**
     * 分隔符
     */
    private static final String SEPARATOR = "&";
    /**
     * 私信加解密key
     */
    private static final String PRIVATE_CHAT_KEY = "hMz1t^neF1Atwt%r";

    /**
     * 生成密文会话id
     * @param currentRole 当前用户角色类型
     * @param mineRoleId
     * @param anotherId
     * @return
     */
    public static String createSessionId(Integer currentRole, Long mineRoleId, Long anotherId) {
        switch (UserRoleEnum.getByRole(currentRole)) {
            case USER:
                return createSessionId(mineRoleId, anotherId);
            case SELLER:
                return createSessionId(anotherId, mineRoleId);
            default:
                throw new IllegalArgumentException("unknow user role.");
        }
    }

    /**
     * 生成密文会话id
     *
     * @param userId
     * @param sellerId
     * @return
     */
    public static String createSessionId(Long userId, Long sellerId) {
        String mingwenSessionId = getMingwenSessionId(userId, sellerId);
        return encode(mingwenSessionId);
    }

    /**
     * 获取会话另一方的角色id
     *
     * @param currentRoleId 当前用户角色id
     * @param sessionId 密文sessionId
     * @return
     */
    public static Long getAnotherId(Long currentRoleId, String sessionId) {
        String mwSessionId = decode(sessionId);
        String[] strs = mwSessionId.split(SEPARATOR);
        List<Long> ids = Arrays.asList(strs).stream()
                .map(Long::valueOf).filter(id -> !currentRoleId.equals(id)).collect(Collectors.toList());
        if (strs.length == ids.size()) {
            throw new IllegalArgumentException("current user don't belong this chat session.");
        }
        return ids.get(0);
    }

    /**
     * 计算明文会话id
     *
     * @param userId
     * @param sellerId
     * @return
     */
    protected static String getMingwenSessionId(Long userId, Long sellerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(sellerId).append(SEPARATOR).append(userId);
        return sb.toString();
    }

    /**
     * 将密文sessionId解密成明文
     * @param miwenSessionId
     * @return
     */
    public static String decode(String miwenSessionId){
        return BlowfishUtils.decryptBlowfish(miwenSessionId,PRIVATE_CHAT_KEY);
    }

    /**
     * 将明文sessionId加密成密文
     * @param mingwenSessionId
     * @return
     */
    public static String encode(String mingwenSessionId){
        return BlowfishUtils.encryptBlowfish(mingwenSessionId,PRIVATE_CHAT_KEY);
    }

}
