package cn.com.duiba.kjy.livecenter.api.enums;

import cn.com.duiba.kjy.livecenter.api.bean.ErrorCodeInterface;

/**
 * Created by dugq on 2020-03-25.
 */
public enum ErrorCode implements ErrorCodeInterface {

    // 99 系统级别
    SYSTEM_ERROR("999999","系统错误"),
    DO_NOT_CARE("990000","不关心错误码的异常，自我消化的异常。特殊标记"),


    // 直播公司
    SAVE_LIVE_USER("100001","保存直播用户失败"),

    //公司管理
    NOT_IN_SAME_TEAM("200001","非团队队员"),


    ;

    private String shortCode;
    private String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "06";
    }

    @Override
    public String getShortCode() {
        return this.shortCode;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
