package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

/**
 * 直播状态
 * @author lizhi
 * @date 2020/3/30 3:27 PM
 */
public enum LiveStatusEnum {
    LIVE_NOTICE(1, "未开始"),
    LIVE_PROCESSING(2, "直播中"),
    LIVE_INTERRUPT(3, "断网"),
    DATA_STATISTIC_ING(4, "数据统计中"),
    DATA_STATISTIC_END(5, "数据统计完成"),
    DATA_STATISTIC_FAILED(6, "数据统计失败,定时任务自动重试"),
    ;

    private Integer code;

    private String desc;

    LiveStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, LiveStatusEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveStatusEnum statusEnum : values()){
            ENUM_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }

    public static LiveStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
