package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 绑定代理人相关
 * @author lizhi
 * @date 2020/6/7 10:13 AM
 */
@AdvancedFeignClient
public interface RemoteOutLiveAgentInvitationService {

    /**
     * 获取当前用户绑定代理人ID
     * @param liveId 直播ID
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.BizTypeEnum
     * @return 绑定代理人ID
     */
    Long findInvitationAgentIdByBiz(Long liveId, String bizUserId, Integer bizType);
}
