package cn.com.duiba.kjy.livecenter.api.enums;

import java.util.Objects;

/**
 * 小程序二维码类型
 * @author lizhi
 * @date 2020/4/12 5:08 PM
 */
public enum QrCodeScenesEnum {

    LIVE_ADMIN_TEAM_INVITE(1, "直播管理员,团队列表页,邀请代理人加入团队"),
    LIVE_ADMIN_LIVE_LIST_SHARE(2, "直播管理员,直播列表分享"),
    LIVE_AGENT_INVITE_USER_SHARE(3, "直播代理人,邀请访客观看直播"),
    LIVE_SPREAD_LINK(4, "直播推广链接小程序码"),
    ;

    /**
     * 场景类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String decs;

    QrCodeScenesEnum(Integer type, String desc) {
        this.type = type;
        this.decs = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDecs() {
        return decs;
    }

    public static QrCodeScenesEnum getByType(Integer type) {
        for (QrCodeScenesEnum typeEnum : QrCodeScenesEnum.values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
