package cn.com.duiba.kjy.paycenter.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 支付中心分配的业务方类型
 * @author lizhi
 * @date 2020/2/28 11:51 AM
 */
public enum BizTypeEnum {

    /**
     * 客集集
     */
    KJJ(3),

    /**
     * 客集集红包
     */
    KJJ_RED_PACKET(6),

    /**
     * 直播红包企业付款到零钱
     */
    KJJ_LIVE_RED_PACKET_WX_COMPANY(7),

    /**
     * 客集集红包_支付宝版
     */
    KJJ_RED_PACKET_4_ALIPAY(8),

    /**
     * 口以小程序付费
     */
    KOUYI_MP_PAY(9),



    /**
     * 兑吧直播红包企业付款到零钱
     */
    DUI_BA_LIVE_RED_PACKET_WX_COMPANY(97),

    ;

    private Integer code;

    BizTypeEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, BizTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(BizTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getCode(), typeEnum);
        }
    }

    public static BizTypeEnum getBizTypeEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    /**
     * 返回bizType是否有效
     * @param bizType 业务方类型
     * @return 是否有效
     */
    public static boolean isActive(Integer bizType) {
        if (bizType == null) {
            return false;
        }
        return getBizTypeEnumByCode(bizType) != null;
    }
}
