package cn.com.duiba.kjy.paycenter.api.enums.wxpay;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/4/1 8:22 PM
 */
public enum WxPayToolTypeEnum {

    /**
     * 微信企业付款到零钱
     */
    WX_COMPANY("wx_com", "微信企业付款到零钱"),

    ;

    private String toolType;
    private String toolName;

    WxPayToolTypeEnum(String toolType, String toolName) {
        this.toolType = toolType;
        this.toolName = toolName;
    }

    public String getToolType() {
        return toolType;
    }

    public String getToolName() {
        return toolName;
    }

    private static final Map<String, WxPayToolTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WxPayToolTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getToolType(), typeEnum);
        }
    }

    public static WxPayToolTypeEnum getByToolType(String toolType) {
        if (toolType == null) {
            return null;
        }
        return ENUM_MAP.get(toolType);
    }
}
