package cn.com.duiba.kjy.paycenter.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.pay.ChargeOrderDto;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.alipay.AliPayWapChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayLiteChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayMpChargeRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.alipay.AliPayWapChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayLiteChargeResponse;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayMpChargeResponse;

import java.util.List;

/**
 * 支付相关
 * @author lizhi
 * @date 2020/3/3 2:07 PM
 */
@AdvancedFeignClient
public interface RemoteChargeService {

    /**
     * 微信公众号支付收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayMpChargeResponse
     */
    WxPayMpChargeResponse createWxPayMpCharge(WxPayMpChargeRequest chargeRequest) throws BizException;

    /**
     * 微信小程序收单接口
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     */
    WxPayLiteChargeResponse createWxPayLiteCharge(WxPayLiteChargeRequest chargeRequest) throws BizException;

    /**
     * 支付宝支付收单接口
     * @param chargeRequest
     * @return
     * @throws BizException
     */
    AliPayWapChargeResponse createAliPayCharge(AliPayWapChargeRequest chargeRequest) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param outTradeNo 支付订单号(商户订单号)
     * @return chargeOrderDto
     */
    ChargeOrderDto findByOutTradeNo(String outTradeNo);

    /**
     * 获取支付订单详情
     * @param bizOrderNo 业务方流水号
     * @param bizType 业务方类型
     * @return ChargeOrderDto
     */
    ChargeOrderDto findByBizOrderNoAndBizType(String bizOrderNo, Integer bizType) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param outTradeNos 支付订单号
     * @return 支付订单集合
     */
    List<ChargeOrderDto> batchFindByOutTradeNo(List<String> outTradeNos) throws BizException;
}
