package cn.com.duiba.kjy.paycenter.api.dto.payment.response.alipay;

import cn.com.duiba.kjy.paycenter.api.annotation.FieldMapKey;
import cn.com.duiba.kjy.paycenter.api.constant.AliPayConstants;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Objects;

/**
 * 支付宝公共响应参数
 * @author 吴文哲
 * @date 2020-07-10 15:26
 **/
@Data
public class AliPayCommonResponse implements Serializable {
    private static final long serialVersionUID = -2327049484524642676L;

    /**
     * 网关返回码
     */
    @FieldMapKey("code")
    @NotBlank(message = "code 不能为空")
    private String code;

    /**
     * 网关返回码描述
     */
    @FieldMapKey("msg")
    @NotBlank(message = "msg 不能为空")
    private String msg;

    /**
     * 业务返回码
     */
    @FieldMapKey("sub_code")
    private String subCode;

    /**
     * 业务返回码描述
     */
    @FieldMapKey("sub_msg")
    private String subMsg;

    /**
     * 签名
     */
    @FieldMapKey("sign")
    @NotBlank(message = "sign 不能为空")
    private String sign;


    public boolean isSuccess() {
        return success || Objects.equals(this.code, AliPayConstants.SUCCESS_CODE)  && Objects.equals(this.msg,AliPayConstants.SUCCESS_MSG);
    }

    private boolean success;
}
