package cn.com.duiba.kjy.paycenter.api.dto.wxpay;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 微信企业付款记录表
 * @author kjj mybatis generator 
 * @date 2020-04-01
 */
@Data
public class WxPayCompanyOrderDto implements Serializable {
     
    private static final long serialVersionUID = 15857240959881616L;

    /**
     * 业务方订单号
     */
    private String bizTradeNo;

    /**
     * 业务方类型，由支付系统分配给各个业务方
     */
    private Integer bizType;

    /**
     * 企业付款金额，单位为分
     */
    private Integer amount;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String appId;

    /**
     * 用户的标识，对公众号唯一
     */
    private String openId;

    /**
     * 描述
     */
    private String desc;

    /**
     * 商户订单号
     */
    private String partnerTradeNo;

    /**
     * 0-初始化状态,1-处理中,2-转账成功,3-转账失败
     * @see cn.com.duiba.kjy.paycenter.api.enums.wxpay.WxPayCompanyPayStatusEnum
     */
    private Integer payStatus;

    /**
     * 企业付款成功，返回的微信付款单号
     */
    private String paymentNo;

    /**
     * 企业付款成功时间
     */
    private String paymentTime;

    /**
     * 错误码信息，注意：出现未明确的错误码时（SYSTEMERROR等），请务必用原商户订单号重试，或通过查询接口确认此次付款的结果。
     */
    private String errCode;

    /**
     * 结果信息描述
     */
    private String errCodeDes;

    /**
     * 转账失败原因
     */
    private String reason;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}