package cn.com.duiba.kjy.paycenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayCompanyQueryRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayCompanyRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayCompanyResponse;
import cn.com.duiba.kjy.paycenter.api.dto.wxpay.WxPayCompanyOrderDto;

/**
 * 微信企业付款到零钱
 * @author lizhi
 * @date 2020/4/1 3:09 PM
 */
@AdvancedFeignClient
public interface RemoteWxPayCompanyService {

    //文档地址：https://pay.weixin.qq.com/wiki/doc/api/tools/mch_pay.php?chapter=14_2

    /**
     * 微信企业付款到零钱
     * @param request 付款参数
     * @return 结果
     */
    @Deprecated
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="3000")
    WxPayCompanyResponse companyPay(WxPayCompanyRequest request);

    /*
     * 改为mq交互，topic：生产-kjyPayAsyncProd，预发-kjyPayAsyncPre，测试-kjyPayAsyncTest，开发-kjyPayAsyncDev
     * tag：cn.com.duiba.kjy.paycenter.api.constant.AsyncRocketMqTag.PAY_WX_COM
     * 参数：cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayCompanyRequest
     * 异步mq回调结构：cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayCompanyResponse
     * 回调topic：数据库配置topic
     * 回调tag：数据库配置tag
     */

    /*
     * 如果业务方长时间未收到结果回调，可以发mq查询结果并触发mq再次推送
     * topic：生产-kjyPayAsyncProd，预发-kjyPayAsyncPre，测试-kjyPayAsyncTest，开发-kjyPayAsyncDev
     * tag：cn.com.duiba.kjy.paycenter.api.constant.AsyncRocketMqTag.PAY_WX_COM_QUERY
     * 参数：cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayCompanyBatchQueryRequest
     * 异步mq回调结构：cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayCompanyResponse
     */

    /*
     * 注意：企业付款到零钱结果通知可能会重复，业务方需要做好幂等
     */

    /**
     * 微信企业付款到零钱查询接口
     * @param request 查询参数
     * @return 结果
     */
    WxPayCompanyOrderDto companyQuery(WxPayCompanyQueryRequest request);
}
