package cn.com.duiba.kjy.paycenter.api.dto.payment.response;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * 支付回调结果
 * @author lizhi
 * @date 2020/3/2 3:14 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseChargeNotifyResponse extends BaseResponse {

    private static final long serialVersionUID = 4822694960206702328L;

    /**
     * 用户支付是否成功
     */
    private boolean chargeSuccess;

    /**
     * 支付订单号(商户订单号)
     */
    private String outTradeNo;
    /**
     * 第三方支付支付流水号
     */
    private String transactionNo;

    /**
     * 分配给业务方的类型和bizOrderNo配合使用
     * bizType + bizOrderNo 保证唯一
     * @see cn.com.duiba.kjy.paycenter.api.enums.BizTypeEnum
     */
    private Integer bizType;

    /**
     * 上游调用方的订单号
     */
    private String bizOrderNo;

    /**
     * 支付完成时间
     */
    private Date paidTime;

    /**
     * 设置错误信息
     * @param notifyResponse 支付回调回执
     * @param errorMsg 错误信息
     * @return 支付回调回执
     */
    public static <T extends BaseChargeNotifyResponse> T buildErrorMsg(T notifyResponse, String errorMsg) {
        if (notifyResponse == null || errorMsg == null) {
            return notifyResponse;
        }
        notifyResponse.setErrorMsg(errorMsg);
        notifyResponse.setChargeSuccess(false);
        return notifyResponse;
    }
}
