package cn.com.duiba.kjy.paycenter.api.param.pay;

import cn.com.duiba.kjy.paycenter.api.param.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 退款订单表
 * @author kjj mybatis generator 
 * @date 2020-02-28
 */
@ToString(callSuper = true)
@Data
@EqualsAndHashCode(callSuper = true)
public class RefundOrderSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15828685582828167L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 退款订单号
     */
    private String outRefundNo;

    /**
     * 支付订单流水号
     */
    private String outTradeNo;

    /**
     * 第三方交易流水号
     */
    private String transactionNo;

    /**
     * 第三方退款流水号
     */
    private String refundNo;

    /**
     * 1 初始化 2 第三方收单失败 3 第三方收单成功 4 退款成功 5 退款失败
     */
    private Integer refundStatus;

    /**
     * 业务方的退款订单id
     */
    private String bizRefundNo;

    /**
     * 业务方类型，由支付系统分配给各个业务方
     */
    private Integer bizType;

    /**
     * 支付渠道
     */
    private String channelType;

    /**
     * 支付渠道应用ID
     */
    private String appId;

    /**
     * 支付金额，单位为分
     */
    private Integer amount;

    /**
     * 申请退款金额，单位为分
     */
    private Integer applyRefundAmount;

    /**
     * 实际退款金额大于0，单位为分
     */
    private Integer refundAmount;

    /**
     * 退款成功时间
     */
    private Date refundTime;

    /**
     * 退款失败后渠道方返回的错误码
     */
    private String failureCode;

    /**
     * 退款失败后渠道方返回的错误描述
     */
    private String failureMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}