package cn.com.duiba.kjy.paycenter.api.remoteservice.wx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.paycenter.api.dto.payment.request.wxpay.WxPayLiteSignRequest;
import cn.com.duiba.kjy.paycenter.api.dto.payment.response.wxpay.WxPayLiteChargeResponse;

/**
 * 微信支付相关
 * @author 吴文哲
 * @date 2021/8/17 4:40 下午
 **/
@AdvancedFeignClient
public interface RemoteWxPayService {

    /**
     * 微信小程序生成签名信息
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     */
    WxPayLiteChargeResponse getWxPayLiteSignInfo(WxPayLiteSignRequest chargeRequest) throws BizException;
}
