package cn.com.duiba.kjy.paycenter.api.util.alipay;

import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author 吴文哲
 * @date 2020-07-09 16:09
 **/
public class MoneyUtil {

    private static final String HUNDREDS = "100";
    /**
     * 把元单位的金额转化成分制
     * @param money
     * @return Long
     */
    public static Long convertToCent (String money) {
        if (StringUtils.isBlank(money)) {
            return 0L;
        }
        return new BigDecimal(HUNDREDS).multiply(new BigDecimal(money)).longValue();
    }

    /**
     * 将分制的金额格式式化为保留2位小数的元制,向下取整
     * @param money
     * @return String
     */
    public static String formatMoneyToKeep2Point (Long money) {
        if (money == null) {
            return "";
        }
        return new BigDecimal(money).divide(new BigDecimal(HUNDREDS), 2, RoundingMode.DOWN).toString();
    }
}
