package cn.com.duiba.kjy.paycenter.api.dto.payment.request.cgb;

import cn.com.duiba.kjy.paycenter.api.dto.payment.request.BaseChargeRequest;
import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author nongfu
 * @Date 2024/10/14 10:47
 */
@Data
@EqualsAndHashCode(callSuper =true)
@ToString(callSuper = true)
public class CgbPayChargeRequest extends BaseChargeRequest {
    /**
     * 一级业务类型
     */
    private String toiBusinessType = "05";
    /**
     * 二级
     */
    private String toiSubBusinessType = "059";
    /**
     * 可与商户订单号一致。或送唯一一串定位交易随机流水
     */
    private String toiSrcFlowNo;
    /**
     * 由合作商户生成的订单号，用于后续清算对账使用。
     */
    private String toiMerchantOrderNo;


    private String toiOrderType = "02";
    /**
     * 商户号
     */
    private String toiMerchantCode  ;
    /**
     * 商户名称
     */
    private String toiMerchantName ;
    /**
     * 人民币
     */
    private String toiCurrency = "156" ;

    /**
     * 订单总金额 单位元
     */
    private String toiOrderTotalAmount  ;

    /**
     * yyyyMMdd
     */
    private String orderConfirmDate ;
    /**
     * HHmmss
     */
    private String orderConfirmTime  ;
    /**
     * Map转JsonString进行上送
     * 业务配置 {"10010":"汽后服务"}
     * 以联调群通知为准
     */
    private String tags  ;
    /**
     * 商品名称
     */
    private String productName  ;
    /**
     * 支付结果页完成按钮URL
     */
    private String orderListUrl  ;
    /**
     * 订单详情URL
      */
    private String orderDetailUrl  ;
    /**
     * 单位元0.00
     * 下单时与订单金额一致
     */
    private String toiOrderCashAmount  ;
    /**
     * 取获取令牌接口的customerNo
     */
    private String toiEcifNo  ;
    /**
     * 接入模式
     */
    private String accessMode  = "003";
    /**
     * 单品名称
     */
    private String singleProductName  ;
    /**
     * 商品数量
     */
    private String productNumber  ;












}
