package cn.com.duiba.kjy.taskcenter.api.constants;

/**
 * @author zhanghuifeng
 * date 2019-04-30-17:02
 */
public enum RedisKeyFactory {

    K001("消息模板缓存"),
    K002("公众号信息缓存"),

    K008("公众号缓存"),

    K010("消息配置根据oaId_mark 的缓存"),
    K011("消息配置根据mark的缓存"),
    K012("种草素材午间推送,oaid对应的查看更多链接缓存"),
    K013("种草素材早报推送,oaid对应的查看更多链接缓存"),

    K018("周报代理人排名"),
    K019("用户类型推送延时缓存"),
    K020("种草素材推送,oaid对应的推送内容缓存"),
    K021("今日热文推送,oaid对应的推送内容缓存"),
    K022("晚安心语推送,oaid对应的推送内容缓存"),
    K023("早报推送,oaid对应的早报推送内容缓存"),
    K024("早报推送,oaid对应的种草素材推送内容缓存"),
    K025("日更海报推送,oaid对应的类型是否有回复语缓存"),

    K030("直播预热抽奖任务，分布式锁"),
    K031("直播预热抽奖任务执行完成，缓存"),

    K072("是否开启免打扰缓存"),

    K107("用户版本信息缓存"),
    K111("节日贺卡访问记录"),

    K121("代理人已推唤醒文案Id缓存"),
    K122("今日唤醒推送的代理人ids"),

    K123("开播提醒已推送用户缓存"),

    K124("开播提醒推送直播用户ids"),

    K125("晚安推送,oaid对应种草素材页面的查看更多链接缓存"),

    K126("直播手动推送分布式锁"),

    K127("每日晚安心语推送情况缓存"),
    K128("每日种草素材推送情况缓存"),
    K129("每日热文推送情况缓存"),
    K130("每日早报推送情况缓存"),
    K140("直播团队榜,以代理人平均邀请排序,直播间纬度,zset的key"),
    K141("直播团队榜,以代理人平均邀请排序,团队纬度rediskey"),
    K142("直播团队榜,团队的数量rediskey"),
    K143("新手教程视频已读缓存"),
    ;

    private static final String SPACE = "TaskCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
