package cn.com.duiba.kjy.teamcenter.api.enums.seller;

/**
 * 代理人团队置顶状态枚举
 * @author zhanghuifeng
 * date 2020/3/24-11:22 上午
 */
public enum SellerTeamStickStateEnum {

    NO(0, "否"),
    YES(1, "是"),
    ;

    private Integer code;

    private String desc;

    SellerTeamStickStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerTeamStickStateEnum getByCode(Integer code) {
        for (SellerTeamStickStateEnum enumVal : SellerTeamStickStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerTeamStickStateEnum enumVal : SellerTeamStickStateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
