package cn.com.duiba.kjy.teamcenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.SellerTeamMemberDataDto;
import cn.com.duiba.kjy.teamcenter.api.dto.SellerTeamPersonStatDto;
import cn.com.duiba.kjy.teamcenter.api.params.Page;
import cn.com.duiba.kjy.teamcenter.api.params.SellerTeamDateInfoParam;

import java.util.List;

/**
 * 销售团队数据remote
 * @author zhanghuifeng
 * date 2020/3/25-3:32 下午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamDataService {

    /**
     * 分页查询团队成员数据
     * @param param
     * @return
     */
    Page<SellerTeamPersonStatDto> pageTeamData(SellerTeamDateInfoParam param);

    /**
     * 分页查询团队直属成员数据
     * @param param
     * @return
     */
    List<SellerTeamMemberDataDto> pageTeamMemberData(SellerTeamDateInfoParam param);
}
