package cn.com.duiba.kjy.teamcenter.api.dto.member;

import cn.com.duiba.kjy.teamcenter.api.enums.member.SellerTeamStickStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售团队成员统计表
*/
@Data
public class SellerTeamMemberStatDto implements Serializable {

    private static final long serialVersionUID = -4202155986769020340L;

    /**
    * 下级销售员id
    */
    private Long sellerId;

    /**
    * 直属上级ID(seller_id)
    */
    private Long superiorId;

    /**
    * 绑定时间
    */
    private Date bindingTime;

    /**
    * 置顶状态，0否，1是
     * @see SellerTeamStickStateEnum
    */
    private Integer stickState;

    /**
    * 下级团队人数
    */
    private Integer sellerTeamCount;

    /**
    * 上级绑定路径
    */
    private String parentPath;

    /**
    * 创建时间
    */
    private Date gmtCreate;

}

