package cn.com.duiba.kjy.teamcenter.api.dto.stat;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 销售团队个人每天数据统计表
*/
@Data
public class SellerTeamPersonDayStatDto implements Serializable {

    private static final long serialVersionUID = -7859622044382063668L;
    /**
    * 销售员id
    */
    private Long sellerId;

    /**
    * 访问量
    */
    private Integer visitCount;

    /**
    * 转发素材量
    */
    private Integer forwardMaterial;

    /**
    * 转发名片
    */
    private Integer forwardCard;

    /**
    * 使用营销工具
    */
    private Integer useMarketingTool;

    /**
    * 获取销售线索
    */
    private Integer gainSaleClue;

    /**
     * 新增跟进客户
     */
    private Integer newFollowCustomer;

    /**
    * 记录类型：1:昨日 2:近7天 
    */
    private Integer recordType;

    /**
    * 记录日期
    */
    private Date recordTime;

}

