package cn.com.duiba.kjy.teamcenter.api.dto.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangbinbin
 * @create 2020-04-24 15:54
 * @descript
 */
@Data
public class SellerTeamTaskDto implements Serializable {

    private static final long serialVersionUID = -5306053175877374910L;

    /**
     * 任务id
     */
    private Long id;

    /**
     * 下发任务的sellerId
     */
    private Long superiorId;

    /**
     * 任务类型
     * @see cn.com.duiba.kjy.teamcenter.api.enums.task.SellerTeamTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 业务关联id
     */
    private Long bizId;

    /**
     * 任务已完成人数
     */
    private Integer taskAchieverNum;

    /**
     * 任务完成需达标人数
     */
    private Integer taskTargetNum;

    /**
     * 任务状态
     * @see cn.com.duiba.kjy.teamcenter.api.enums.task.SellerTeamTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 发布时间
     */
    private Date gmtCreate;

    /**
     * 截止日期
     */
    private Date deadlineTime;

    /**
     * 任务是否以完善
     * @see cn.com.duiba.kjy.teamcenter.api.enums.task.SellerTeamTaskIsCompletedEnum
     */
    private Integer isCompleted;

    /**
     * 任务上次提醒时间
     */
    private Date lastRemindTime;

}
