package cn.com.duiba.kjy.teamcenter.api.enums;

/**
 * @author  d
 * @date 2020/3/30 2:34 PM
 */
public enum RedisKeyFactory {
    K001("任务处理 分布式锁"),
    K002("任务初始化 分布式锁"),
    K134("代理人团队绑定/删除上下级 分布式锁"),
    K135("代理人初始化看板数据 分布式锁"),
    ;

    private static final String SPACE = "KjyTeamCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
