package cn.com.duiba.kjy.teamcenter.api.enums.stat;

/**
 * 销售团队数据类型枚举
 * @author zhanghuifeng
 * date 2020/3/25-3:23 下午
 */
public enum SellerTeamDateTypeEnum {

    visit_count(1, "访问量"),
    forward_material(2, "转发素材量"),
    forward_card(3, "转发名片"),
    use_marketing_tool(4, "使用营销工具"),
    gain_sale_clue(5, "获取销售线索"),
    ;

    private Integer code;

    private String desc;

    SellerTeamDateTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerTeamDateTypeEnum getByCode(Integer code) {
        for (SellerTeamDateTypeEnum enumVal : SellerTeamDateTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerTeamDateTypeEnum enumVal : SellerTeamDateTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
