package cn.com.duiba.kjy.teamcenter.api.enums.stat;

/**
 * @auther: linjianhui
 * @date: 2020-04-28 16:04
 * @description: 团队长看板各个排行类型
 */
public enum TeamRankingSearchEnum {

    /**
     * 列表类型 1：跟进  2：获得线索 3:总跟进客户 4:转发素材 5：转发名片 6:送礼邀约
     */
    NEW_FOLLOW(1, "新增跟进客户"),
    GAIN_SALE_CLUE(2, "获取销售线索"),
    TOTAL_NEW_FOLLOW(3,"总跟进客户"),
    FORWARD_MATERIAL(4, "转发素材量"),
    FORWARD_CARD(5, "转发名片"),
    USE_MARKETING_TOOL(6, "使用营销工具"),
    ;

    private Integer code;

    private String desc;

    TeamRankingSearchEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static TeamRankingSearchEnum getByCode(Integer code) {
        for (TeamRankingSearchEnum enumVal : TeamRankingSearchEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
