package cn.com.duiba.kjy.teamcenter.api.params;

import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2019-02-14 14:32
 * @description:
 */
@Data
public class Page<T extends Serializable> implements Serializable {

    private static final long serialVersionUID = 8612016981015649395L;
    /** 分页数据 */
    private List<T> list = Collections.emptyList();

    /** 当前页码 */
    private int pageNo;

    /** 分页大小 */
    private int pageSize;

    /** 总页数 */
    private int totalPages;

    /** 总记录数 */
    private int totalCount;

    /**
     * 是否有下一页
     */
    private Boolean hasNext;

}
