package cn.com.duiba.kjy.teamcenter.api.params.stat;

import cn.com.duiba.kjy.teamcenter.api.enums.stat.TeamRankingSearchEnum;
import cn.com.duiba.kjy.teamcenter.api.enums.stat.SellerTeamStatRecordTypeEnum;
import cn.com.duiba.kjy.teamcenter.api.params.PageQuery;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2020-04-28 11:55
 * @description:  团队长看板各个排行列表，查询参数
 */
@Data
public class TeamRankingSearchParams extends PageQuery {

    /**
     * 团队中销售id
     */
    private Long superiorId;

    /**
     *
     * {@link TeamRankingSearchEnum}
     */
    private Integer rankingType;

    /**
     * 记录类型 1:昨日 2:近7日 3:累计
     * @see SellerTeamStatRecordTypeEnum
     */
    private Integer recordType;

    /**
     * 直属下属销售id列表
     */
    private List<Long> sellerIds;

    /**
     * 记录开始时间
     */
    private Date startTime;

    /**
     * 记录结束时间
     */
    private Date endTime;

    /**
     * 分页偏移量
     */
    private Integer customOffset;
}
