package cn.com.duiba.kjy.teamcenter.api.remoteservice.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.member.SellerTeamRankingDto;
import cn.com.duiba.kjy.teamcenter.api.dto.stat.SellerTeamMemberDataDto;
import cn.com.duiba.kjy.teamcenter.api.dto.stat.SellerTeamPersonStatDto;
import cn.com.duiba.kjy.teamcenter.api.params.Page;
import cn.com.duiba.kjy.teamcenter.api.params.stat.TeamRankingSearchParams;
import cn.com.duiba.kjy.teamcenter.api.params.stat.SellerTeamDateInfoParam;

import java.util.List;

/**
 * 销售团队数据remote
 * @author zhanghuifeng
 * date 2020/3/25-3:32 下午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamDataService {

    /**
     * 分页查询团队成员数据
     * @param param
     * @return
     */
    @Deprecated
    Page<SellerTeamPersonStatDto> pageTeamData(SellerTeamDateInfoParam param);

    /**
     * 分页查询团队直属成员数据
     * @param param
     * @return
     */
    @Deprecated
    List<SellerTeamMemberDataDto> pageTeamMemberData(SellerTeamDateInfoParam param);

    /**
     * 团队长看板各个排行分页数据
     * @param param
     * @return
     */
    Page<SellerTeamRankingDto> teamRankingPage(TeamRankingSearchParams param);

}
