package cn.com.duiba.kjy.teamcenter.api.remoteservice.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.stat.SellerTeamDaySumStatDto;
import cn.com.duiba.kjy.teamcenter.api.dto.stat.SellerTeamPersonDayStatDto;
import cn.com.duiba.kjy.teamcenter.api.enums.stat.SellerTeamStatRecordTypeEnum;

import java.util.Date;

/**
 * 代理人个人每天统计数据remote
 * @author zhanghuifeng
 * date 2020/3/24-4:53 下午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamPersonDayStatService {

    /**
     * 根据代理人ID和记录类型查询时间区间内数据(最近一条数据）
     * @param sellerId
     * @param startTime
     * @param endTime
     * @param recordType {@link SellerTeamStatRecordTypeEnum}
     * @return
     */
    SellerTeamPersonDayStatDto findBySidAndTimeAndType(Long sellerId, Date startTime, Date endTime, Integer recordType);

    /**
     * 根据代理人ID和记录类型查询时间区间内求和数据
     * @param sellerId
     * @param startTime
     * @param endTime
     * @param recordType {@link SellerTeamStatRecordTypeEnum}
     * @return
     */
    SellerTeamDaySumStatDto sumBySidAndTimeAndType(Long sellerId, Date startTime, Date endTime, Integer recordType);
}
