package cn.com.duiba.kjy.teamcenter.api.remoteservice.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.stat.SellerTeamPersonStatDto;

import java.util.Date;

/**
 * 代理人个人累计统计数据remote
 * @author zhanghuifeng
 * date 2020/3/24-4:22 下午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamPersonStatService {

    /**
     * 根据代理人ID和时间获取个人累计数据(最近一条数据）
     * @param sellerId
     * @param startTime
     * @param endTime
     * @return
     */
    SellerTeamPersonStatDto findBySellerIdAndTime(Long sellerId, Date startTime, Date endTime);
}
