package cn.com.duiba.kjy.teamcenter.api.remoteservice.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.stat.SellerTeamStatDto;

import java.util.Date;

/**
 * 代理人团队累计统计数据remote
 * @author zhanghuifeng
 * date 2020/3/24-4:22 下午
 */
@AdvancedFeignClient
public interface RemoteSellerTeamStatService {

    /**
     * 根据代理人ID和时间获取团队累计数据(最近一条数据）
     * @param sellerId
     * @param startTime
     * @param endTime
     * @return
     */
    SellerTeamStatDto findBySellerIdAndTime(Long sellerId, Date startTime, Date endTime);
}
