package cn.com.duiba.kjy.teamcenter.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-04-26 10:22
 * @descript 任务接收人remoteService
 */
@AdvancedFeignClient
public interface RemoteSellerTeamTaskReceiverService {

    /**
     * 初始化任务接收人并发送消息
     * @param taskId
     * @param isAllMen
     * @param superiorIds
     * @param receiveSellerIds
     */
    void initTaskReceiverAndSendMsg(Long taskId, boolean isAllMen, List<Long> superiorIds, List<Long> receiveSellerIds);

    /**
     * 根据任务分页查询
     * @param taskId
     * @param type
     * @param lastId
     * @param pageSize
     * @return
     */
    List<Long> listSellerIdsByTaskId(Long taskId, Integer type, Long lastId, int pageSize);

    /**
     * 查询接收人总数
     * @param taskStatus
     * @param taskId
     * @return
     */
    int countReceiverNum(Integer taskStatus, Long taskId);

    /**
     * 根据代理人和任务状态统计数量
     * @param taskStatus
     * @param sellerId
     * @return
     */
    int countBySidAndTaskStatus(Integer taskStatus, Long sellerId);

    /**
     * 我的任务列表 分页查询任务ids
     * @param taskStatus
     * @param lastTaskId
     * @param pageSize
     * @param sellerId
     * @return
     */
    List<Long> listTaskIdsPage(Integer taskStatus, Long lastTaskId, Integer pageSize, Long sellerId);

    /**
     * 查询代理人最新的未完成任务的创建时间
     * @param sellerId
     * @return
     */
    Date getLastToDoTaskCreateTime(Long sellerId);

    /**
     * 处理转发任务
     * @param contentId
     * @param sellerId
     */
    void dealForwardTask(Long contentId, Long sellerId);
}
