package cn.com.duiba.kjy.teamcenter.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-04-26 17:39
 * @descript 任务关系remoteService
 */
@AdvancedFeignClient
public interface RemoteSellerTeamTaskRelationService {

    /**
     * 根据上级查询其任务id列表
     * @param superiorId
     * @param taskStatus
     * @param lastTaskId
     * @param pageSize
     * @return
     */
    List<Long> listTaskIdBySuperiorId(Long superiorId, Integer taskStatus, Long lastTaskId, int pageSize);

    /**
     * 查询任务总数
     * @param superiorId
     * @param taskStatus
     * @return
     */
    int countTaskIdBySuperiorId(Long superiorId, Integer taskStatus);

}
