package cn.com.duiba.kjy.teamcenter.api.remoteservice.task;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.teamcenter.api.dto.task.SellerTeamTaskDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-04-24 16:53
 * @descript boss看板任务 remoteService
 */
@AdvancedFeignClient
public interface RemoteSellerTeamTaskService {

    /**
     * 创建任务
     * @param sellerId
     * @param contentId
     * @return -1L=没有下级 -2L=任务已存在
     */
    Long createTask(Long sellerId, Long contentId);

    /**
     * 获取任务详情
     * @param taskId
     * @return
     */
    SellerTeamTaskDto getTaskDetail(Long taskId);

    /**
     * 更新任务
     * @param sellerTeamTaskDto
     * @return
     */
    boolean updateByTaskId(SellerTeamTaskDto sellerTeamTaskDto);

    /**
     * 根据任务ids批量查询
     * @param taskIds
     * @return
     */
    List<SellerTeamTaskDto> listByTaskIds(List<Long> taskIds);

    /**
     * 根据任务id查询bizId
     * @param taskId
     * @return
     */
    Long findBizIdById(Long taskId);

    /**
     * 根据任务id查询上级发布人id
     * @param taskId
     * @return
     */
    Long findSuperiorIdById(Long taskId);

    /**
     * 发送提醒消息
     * @param taskId 任务id
     * @param remindType 提醒类型
     * @param sellerId 触发提醒的代理人id
     * @return
     */
    boolean sendRemindMsg(Long taskId, Integer remindType, Long sellerId);

}
