package cn.com.duiba.kjy.voice.service.api.dto.voiceagent;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;

/**
 * 语音直播代理人表
 * @author kjj mybatis generator 
 * @date 2021-02-06
 */
@Data
public class VoiceAgentDto implements Serializable {
     
    private static final long serialVersionUID = 16125782913494931L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播代理人ID
     */
    private Long agentId;

    /**
     * 是否完成实名认证 0:否 1:是
     */
    private Integer auth;
    /**
     * 认证的名字
     */
    private String name;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 图像识别的真实姓名
     */
    private String ocrName;

    /**
     * 图像识别的民族
     */
    private String ocrNation;

    /**
     * 图像识别的身份证地址
     */
    private String ocrAddress;

    /**
     * 图片识别的生日
     */
    private LocalDate ocrBirth;

    /**
     * 图像识别的身份证签发机关
     */
    private String ocrAuthority;

    /**
     * 图像识别的身份证有效期
     */
    private Date ocrValidDate;

    /**
     * 图像识别的身份证号
     */
    private String ocrIdCard;

    /**
     * 图像识别的性别
     */
    private Integer ocrGender;

    /**
     * 身份证正面图
     */
    private String idCardFront;

    /**
     * 身份证反面照片
     */
    private String idCardBack;

    /**
     * 活体识别视频
     */
    private String ocrVideo;

    /**
     * 活体识别最佳图片桢
     */
    private String ocrVideoFrame;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}