package cn.com.duiba.kjy.voice.service.api.dto.voicelive;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 语音直播表
 * @author kjj mybatis generator 
 * @date 2021-02-06
 */
@Data
public class VoiceLiveDto implements Serializable {
     
    private static final long serialVersionUID = 16125782913476738L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播代理人ID
     */
    private Long agentId;

    /**
     * 直播间ID
     */
    private Long roomId;

    /**
     * 直播标题
     */
    private String title;

    /**
     * 宣传海报
     */
    private String posterUrl;

    /**
     * 开播时间
     */
    private Date broadcastTime;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-数据统计中 5-数据统计完成 6-数据统计失败
     */
    private Integer liveStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}