package cn.com.duiba.kjy.voice.service.api.remoteservice.voiceuserappointment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.voice.service.api.dto.voiceuserappointment.VoiceUserAppointmentDto;
import cn.com.duiba.kjy.voice.service.api.dto.voiceuserappointment.VoiceUserAppointmentNumDto;
import cn.com.duiba.kjy.voice.service.api.param.voiceuserappointment.VoiceUserAppointmentSearchParam;

import java.util.List;

/**
 * 语音直播用户预约service
 * @Author chentiecheng
 * @Date 2021/2/6 2:54 下午
 */
@AdvancedFeignClient
public interface RemoteVoiceUserAppointmentService {

    /**
     * 根据直播间id列表获取预约人数
     * @param voiceIds
     * @return
     */
    List<VoiceUserAppointmentNumDto> selectAppointmentNumByVoiceIds(List<Long> voiceIds);

    /**
     * 分页查询直播预约列表
     * @param param
     * @return
     */
    List<VoiceUserAppointmentDto> selectAppointmenyByCondition(VoiceUserAppointmentSearchParam param);

}
