package cn.com.duiba.kjy.api.api.param;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/** 早安海报请求参数
 * @Author chentiecheng
 * @Date 2020/10/12 11:59 上午
 */
@Data
public class DailyPosterParam implements Serializable {
    private static final long serialVersionUID = 6125756543748816136L;
    /**
     * 海报背景图
     */
    private String poster;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 小程序二维码
     */
    private String qrCode;
    /**
     * 图片文案
     */
    private String imgContent;
    /**
     * 打卡天数
     */
    private Integer clockInTime;

    /**
     * 公众号id
     */
    private Long oaId;

    /**
     * openId
     */
    private String openId;
    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 推送文案
     */
    private String content;

    /**
     * 是否是试推
     */
    private Boolean isTryPush;

    /**
     * 推送事件
     */
    private String pushEventType;

    /**
     * 是否是菜单推送
     */
    private Boolean isMenuPush;

    /**
     * 打卡时间
     */
    private Date clockTime;

    /**
     * 早晚安标记
     */
    private String clockText;

    /**
     * 是否早安打卡
     */
    private Boolean morningClock;

}
