package cn.com.duiba.kjy.api.api.dto.menu;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 菜单
 * @author lizhi
 * @date 2020/9/29 11:51 AM
 */
@Data
public class ButtonDto implements Serializable {

    private static final long serialVersionUID = 4850507823817942567L;

    /**
     * 菜单标题，不超过16个字节，子菜单不超过60个字节
     */
    private String name;

    /**
     * 菜单的响应动作类型，view表示网页类型，click表示点击类型，miniprogram表示小程序类型
     */
    private String type;

    /**
     * 网页 链接
     */
    private String url;

    /**
     * 小程序的appid（仅认证公众号可配置），miniprogram类型必须
     */
    @JSONField(name = "appid")
    private String appId;

    /**
     * 小程序的页面路径，miniprogram类型必须
     */
    @JSONField(name = "pagepath")
    private String pagePath;

    /**
     * 菜单KEY值，用于消息接口推送，不超过128字节，click等点击类型必须
     */
    private String key;

    /**
     * 二级菜单数组，个数应为1~5个
     */
    @JSONField(name = "sub_button")
    private List<SubButtonDto> subButton;
}
